#pragma once
#include "afxcmn.h"
#include "afxwin.h"
#include "ProfileDll.h"
#include "ServiceDlg.h"
#include "ListCtrlEx.h"
/////////////////////////////////////////////////////////////////////////////
#define kTypeColumnIndex			0
#define kLineIDColumnIndex			1
#define kOPNColumnIndex				2
#define kStatusColumnIndex			3
/////////////////////////////////////////////////////////////////////////////
// CConfigGPRSDlg dialog
class CServiceSPCDlg : public CServiceDlg
{
	DECLARE_DYNAMIC(CServiceSPCDlg)
private:
	virtual int		GetIconId()		{ return IDI_ICON_SPC; };
public:
	enum {	IDD = IDD_DLGSVC_SPC_MAIN	};
	CServiceSPCDlg(CService* iSvcSPC) : CServiceDlg(CServiceSPCDlg::IDD, theApp.m_hInstance, iSvcSPC){};
	virtual ~CServiceSPCDlg() {};	
protected:
	virtual void DoDataExchange(CDataExchange* pDX)	{ CDialog::DoDataExchange(pDX); };
	DECLARE_MESSAGE_MAP()
public:
	virtual BOOL	OnInitDialog()	{ CDialog::OnInitDialog(); return TRUE; };
	virtual char*	GetName()		{ return "Speech";};
	virtual void	UpdateDisplay()	{};
	virtual BOOL	Apply()			{ return TRUE; };
};
/////////////////////////////////////////////////////////////////////////////
class CServiceSPCDlgNew : public CServiceDlg
{
	DECLARE_DYNAMIC(CServiceSPCDlgNew)

public:
	CServiceSPCDlgNew(CService* iSvcSPC) : CServiceDlg(CServiceSPCDlgNew::IDD, theApp.m_hInstance, iSvcSPC){};
	virtual ~CServiceSPCDlgNew(){};

	// Dialog Data
	enum { IDD = IDD_DLGSVC_SPC_NEW };

	virtual void	UpdateDisplay()	{};
	virtual char*	GetName()	{ return "New Call"; };
	virtual BOOL	OnInitDialog();
	virtual BOOL	Apply()		{return TRUE;};

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	DECLARE_MESSAGE_MAP()
public:
	CButton		mCheckFwd;
	CEdit		mEditNumber;
	CEdit		mEditName;

	afx_msg void OnBnClickedButtonIncomingCall();
};
/////////////////////////////////////////////////////////////////////////////
class CServiceSPCDlgManage : public CServiceDlg
{
	DECLARE_DYNAMIC(CServiceSPCDlgManage)

public:
	CServiceSPCDlgManage(CService* iSvcSPC) : CServiceDlg(CServiceSPCDlgManage::IDD, theApp.m_hInstance, iSvcSPC){};
	virtual ~CServiceSPCDlgManage(){};

	// Dialog Data
	enum { IDD = IDD_DLGSVC_SPC_MANAGE };

	virtual void	UpdateDisplay();
	virtual char*	GetName()	{ return "Manage Calls"; };
	virtual BOOL	OnInitDialog();
	virtual BOOL	Apply()		{return TRUE;};

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	DECLARE_MESSAGE_MAP()
public:
	CListCtrlEx		mListOpened;
	CListBox		mListCSSU, mListCSSI;
	CButton			mBtnConnect, mBtnAlerting, mBtnError, mBtnBusy, mBtnRelease;
public:	
	afx_msg void 	OnBnClickedButtonAlerting();
	afx_msg void 	OnBnClickedButtonConnect();
	afx_msg void 	OnBnClickedButtonError();
	afx_msg void 	OnBnClickedButtonBusy();
	afx_msg void 	OnBnClickedButtonRelease();
	afx_msg void 	OnLvnItemchangedListOpened(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void 	OnLbnDblclkListCssu();
	afx_msg void 	OnLbnDblclkListCssi();	
	afx_msg void OnNMClickListOpened(NMHDR *pNMHDR, LRESULT *pResult);
};
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
